#include <iostream>
using namespace std;

#define min(a,b) ((a)<(b)?(a):(b))
#define sf(n)       scanf("%d", &n)

int width [1000010];
long long ans;
int n;

bool do_subtractions() {
    // return true if change was made
    int i = -1;
    bool did_change = false;
    while (++i < n) {
        int new_value = width[i];
        if (i > 0) {
            new_value = min(new_value, width[i-1] + 1);
        }
        if (i < n - 1) {
            new_value = min(new_value, width[i+1] + 1);
        }

        int delta = width[i] - new_value;
        
        did_change |= !!delta;
        ans += delta;
        width[i] = new_value;
    }
    return did_change;
}

int main() {
    // A O(n^2) solution to the sandpaper problem.
    // This solution will iterate through the list repeatedly and
    // adjust every element to fit both its neighbors.
    // Should reach worst case on a list with pattern: (...) 9 7 5 3 1.
    sf(n);
    int i = -1;
    while (++i < n)
    {
        sf(width[i]);
    }
    
    ans = 0;
    while (do_subtractions());

    cout << ans << endl; 
    return 0;
}
