#!/usr/bin/env python3
import sys, argparse, random

parser = argparse.ArgumentParser(description="Generator for sandpaper.")    
parser.add_argument('-n', metavar='N', type=int, required=True, help='length of plank')
parser.add_argument('-k', metavar='K', type=int, default=None, help='max thikness (inclusive)')
parser.add_argument('-o', metavar='O', type=str, default="random", help='options')
parser.add_argument('-s', metavar='S', type=int, default=None, help='seed')
args = parser.parse_args()
random.seed(args.s)

n = args.n
rangebound = args.k + 1 if args.k > 0 else n*2
options = args.o

nums = list(range(1, n+1)) if ("distinct" in options) else [random.randrange(1, rangebound) for _ in range(n)]

if "maxvals" in options:
    nums = [rangebound - 1 for _ in range(n)]

if "alternate" in options:
    for i in range(0, n, 2):
        nums[i] = 1

if "difftwo" in options:
    nums = [x*2 for x in nums]

if "inc" in options:
    nums.sort()

if "rev" in options:
    nums.reverse()

if "twotimes" in options:
    for i in range(n-1, n//2-1, -1):
        nums[i] = nums[i - n//2]

## Note: option noise MUST be the last option in the option string,
# and must be followed by an integer
if ("noise" in options):
    noiselevel = int(options[options.index("noise")+len("noise"):])
    for _ in range(noiselevel):
        i = random.randrange(n)
        nums[i] = random.randrange(1, rangebound)

print(n)
print(" ".join(str(x) for x in nums))
