#!/usr/bin/env python3

# Constants
BEG = 0
END = 1
ATT = 2

# Read input
n = int(input())
artists = [list(map(int, input().split())) for _ in range(n)]

# Time compression
times = set()
for beg, end, utility in artists:
    times.add(beg)
    times.add(end)

compressed_time = {}
for i, time in enumerate(sorted(times)):
    compressed_time[time] = i

for artist in artists:
    artist[0] = compressed_time[artist[0]]
    artist[1] = compressed_time[artist[1]]

# Sort by end time
artists.sort(key=lambda x: x[END])

# Dynamic programming. DP[i] is the maximum attention possible to
# acheive with a concert ending at or before time i.
# DP[0] = 0 (since every concert last at least 1 unit time)
# DP[i] = max(DP[i-1], DP[beg] + att for every concert ending at i)
dp = [0] * (len(times) + 2)
t = 0
i = 0
while t < len(dp) - 1:
    if i < len(artists) and artists[i][END] == t:
        dp[t] = max(dp[t], dp[artists[i][BEG]] + artists[i][ATT])
        i += 1
    else:
        t += 1
        dp[t] = dp[t-1]

assert(i == len(artists))

print(dp[-1])
