#!/usr/bin/env python3

def how_many_times_to_get_100(twos, threes):
    # Observation 1: We must always use an even number of threes every time
    # Hence, we work with "sixes" instead
    sixes = threes // 2

    # Observation 2: Twos are strictly more flexible than sixes; everything
    # we can do with value x in sixes, we can do with value x in twos.
    # Hence, a good strategy is to get rid of as many sixes as possible at
    # each turn.

    # First step: as many times as possible, pick 96 with sixes + 4 with twos
    max_num_sixes = 100 // 6
    rest_num_twos = (100 - 6 * max_num_sixes) // 2

    max_96_plus_4 = min(sixes // max_num_sixes, twos // rest_num_twos)

    count = max_96_plus_4
    sixes -= max_num_sixes * max_96_plus_4
    twos -= rest_num_twos * max_96_plus_4

    # From now on, I can't make 96 + 4  -- either not enough twos, or not
    # enough sixes. If not enough two's, I'm done. 
    if (twos < rest_num_twos):
        return count

    # Now assume not enough sixes. Pick all sixes, then fill up with two's.
    # value_of_sixes = sixes * 6
    # required_twos = (100 - value_of_sixes) // 2
    # if (required_twos <= twos):
    #     sixes = 0
    #     twos -= required_twos
    #     count += 1

    # From now on, there are no sixes left. Do as much as possible with two's.
    count += (twos * 2) // 100
    return count

print(how_many_times_to_get_100(*map(int, input().split())))
