#!/usr/bin/env bash

### Master generator (run this from the ./generators folder to generate)
MAXN=400000
MAXP=1000000

## Solver
# g++ -O2 ../submissions/accepted/torstein.cpp -o /tmp/a.out
SOLVER=../submissions/accepted/torstein-py3.py

## Destination for generated files
# CAREFUL! EVERYTHING IN THIS DIRECTORY WILL BE ERASED
DESTBASE="../data/secret/gen"
rm -r -f $DESTBASE
mkdir $DESTBASE
DEST="${DESTBASE}"
echo $DEST

# Calling the generation script
COUNT=0
generate() {
    ((COUNT++))
    printf -v padCount "%02d" $COUNT
    ./gen_int_list.py -s $COUNT -n $1 -l 1 -u $2 -o $3 > $DEST/${padCount}_n$1_k$2_$3.in
}

# Call generator with these flags
for n in 19 $MAXN
do
    generate $n 5 ran
    generate $n 0 ran
    generate $n $MAXP ran
    generate $((n / 2)) 0 ran-mirror
    generate $n $MAXP ran
    generate $((n / 2)) $MAXP ran-mirror
    generate $n $MAXP inv
    generate $n 0 ran-setMax$((n - 1))
    generate $n $MAXP ran-setMax$((n - 2))
    generate $n 0 inc
    generate $n 0 inc-rev
    generate $((n / 2)) 0 inc-mirror
    generate $((n / 2)) 0 inc-rev-mirror
    generate $((n / 2)) 0 inc-rep2-shift2
    generate $((n / 2)) 0 inc-rep2-rev-shift2
    generate $((n / 2)) 0 inc-mirror-noise5
    generate $((n / 2)) 0 inc-rev-mirror-noise5
    generate $((n / 2)) 0 inc-rep2-shift3-noise5
    generate $((n / 2)) 0 inc-rep2-rev-shift3-noise5
done

# Generate solutions
if [[ ! -z $SOLVER ]]
then
    for f in $DEST/*.in
    do
        echo "solving $f"
        $SOLVER < $f > ${f%???}.ans
    done
fi
