#!/usr/bin/env python3
n, k = map(int, input().split())
shopping_items = input().split()
order = input().split()

# create a dictionary of categories and their sorting order
category_order = {category: i for i, category in enumerate(order)}

categories = {}
for _ in range(k):
    cat_c_elems = input().split()
    category = cat_c_elems[0]
    count = int(cat_c_elems[1])
    for i in range(count):
        categories[cat_c_elems[i + 2]] = category

# bucket sorting the items into categories
buckets = [[] for _ in range(k)]
for item in shopping_items:
    # place the items into buckets based on their category's sorting order
    buckets[category_order[categories[item]]].append(item)

# flatten the buckets into a long one dimension list
flat_shopping = [item for bucket in buckets for item in bucket]

# join the elements to get the answer
print(" ".join(flat_shopping))
