#!/usr/bin/env bash

### Master generator (run this from the ./generators folder to generate)
MAXN=100000

## Solver
SOLVER=../submissions/accepted/torstein.py

## Destination for generated files
# CAREFUL! EVERYTHING IN THIS DIRECTORY WILL BE ERASED
DESTBASE="../data/secret/gen"
rm -r -f $DESTBASE
mkdir $DESTBASE
DEST="${DESTBASE}"
echo $DEST

# Calling the generation script
COUNT=0
generate() {
    ((COUNT++))
    printf -v padCount "%02d" $COUNT
    ./generate.py -s $COUNT -n $1 -k $2 > $DEST/${padCount}_n$1_k$2.in
}

# Call generator with these flags
for n in 25 $MAXN
do
    sn=`echo "sqrt($n)" | bc`
    generate $n 1
    generate $n 2
    generate $n $sn
    generate $n $((n / 3))
    generate $n $n
done

# Generate solutions
if [[ ! -z $SOLVER ]]
then
    for f in $DEST/*.in
    do
        echo "solving $f"
        $SOLVER < $f > ${f%???}.ans
    done
fi