#!/usr/bin/env python3

h, w, n = map(int, input().split())

# initialize all stops as possible choices -> one
accepted_stops = [1] * n
stops = [[] for _ in range(n)]

# store the stops in a 2d list
for i in range(n):
    for _ in range(h):
        stops[i].append(input())

# go through the current sign, pixel by pixel
# and check if a working pixel is missing from
# stops. If it does, set its value to zero
for row in range(h):
    line = input()
    for pixel in range(len(line)):
        for i in range(n):
            if line[pixel] == "x" and stops[i][row][pixel] != "x":
                accepted_stops[i] = 0

# check if theres only one possible left,
# which means only one element in the list 1,
# so the sum == 1
if sum(accepted_stops) == 1:
    print("yes")
else:
    print("no")