#!/usr/bin/env bash

# t (h): 100
# w    : 100
# n    : 100

SEED=1337

DESTINATION="../data/secret/generated"
rm -rf $DESTINATION
mkdir -p $DESTINATION

./generate.py -t 3 -w 3 -n 1 -o "yes" -s $((SEED+1)) > $DESTINATION/secret_$SEED.in
SEED=$((SEED+1))
./generate.py -t 3 -w 3 -n 6 -o "yes" -s $((SEED+2)) > $DESTINATION/secret_$SEED.in
SEED=$((SEED+1))
./generate.py -t 10 -w 10 -n 100 -o "yes" -s $((SEED+3)) > $DESTINATION/secret_$SEED.in
SEED=$((SEED+1))
./generate.py -t 100 -w 100 -n 100 -o "yes" -s $((SEED+4)) > $DESTINATION/secret_$SEED.in
SEED=$((SEED+1))
./generate.py -t 100 -w 100 -n 100 -o "yes" -s $((SEED+5)) > $DESTINATION/secret_$SEED.in
SEED=$((SEED+1))
./generate.py -t 3 -w 3 -n 100 -o "maybe_no" -s $((SEED+6)) > $DESTINATION/secret_$SEED.in
SEED=$((SEED+1))
./generate.py -t 10 -w 10 -n 100 -o "maybe_no" -s $((SEED+7)) > $DESTINATION/secret_$SEED.in
SEED=$((SEED+1))
./generate.py -t 100 -w 100 -n 50 -o "maybe_no" -s $((SEED+8)) > $DESTINATION/secret_$SEED.in
SEED=$((SEED+1))
./generate.py -t 30 -w 30 -n 70 -o "maybe_no" -s $((SEED+9)) > $DESTINATION/secret_$SEED.in

for i in $(seq 1 10)
do
    SEED=$((SEED+1))
    ./generate.py -t 10 -w 10 -n 10 -o "maybe_no" -s $SEED > $DESTINATION/secret_$SEED.in
    SEED=$((SEED+1))
    ./generate.py -t 10 -w 10 -n 10 -o "yes" -s $SEED > $DESTINATION/secret_$SEED.in
done

for f in $DESTINATION/*.in
do
    echo "solving $f"
    ../submissions/accepted/petter.py < $f > ${f%???}.ans
done
