#!/usr/bin/env python3
import sys, argparse, random

def main():
    parser = argparse.ArgumentParser(description="Generator for the trainstops problem.")
    parser.add_argument('-t', metavar='T', type=int, required=True, help='height of screen')
    parser.add_argument('-w', metavar='W', type=int, required=True, help='width of screen')
    parser.add_argument('-n', metavar='N', type=int, required=True, help='number of stops')
    parser.add_argument('-o', metavar='O', type=str, required=True, help='option')
    parser.add_argument('-s', metavar='S', type=int, required=True, help='seed')
    args = parser.parse_args()

    random.seed(args.s)

    if args.o == "yes":
        yes(args)
    else:
        maybe_no(args)

def yes(args):
    print(args.t, args.w, args.n)
    stop = random_arr(args.t*args.w, 0.8)
    screen = random_drop_pixels(stop, 0.8)
    print_screen(args.w, stop)
    for i in range(args.n-1):
        non_match = random_drop_pixels(screen, 0.2)
        print_screen(args.w, non_match)
    print_screen(args.w, screen)

def maybe_no(args):
    print(args.t, args.w, args.n)
    stop = random_arr(args.t*args.w, 0.8)
    screen = random_drop_pixels(stop, 0.8)
    print_screen(args.w, stop)
    for i in range(args.n-1):
        if random.random() < 0.1:
            match = random_add_pixels(screen, 0.2)
            print_screen(args.w, match)
        else:
            non_match = random_drop_pixels(screen, 0.2)
            print_screen(args.w, non_match)
    print_screen(args.w, screen)
    pass

def random_arr(l, p):
    screen = []
    for _ in range(l):
        if random.random() < p:
            screen.append('x')
        else:
            screen.append('.')
    return screen

def random_drop_pixels(arr, p):
    cp = []
    for e in arr:
        if e == ' ':
            cp.append(e)
        else:
            if random.random() < p:
                cp.append(e)
            else:
                cp.append('.')
    return cp

def random_add_pixels(arr, p):
    cp = []
    for e in arr:
        if e == ' ':
            if random.random() < p:
                cp.append(e)
            else:
                cp.append('x')
        else:
            cp.append(e)
    return cp

def print_screen(w, screen):
    for i in range(len(screen) // w):
        print("".join(screen[i*w:(i+1)*w]))

if __name__ == "__main__":
    main()
