#include <iostream>

using namespace std;
#define min(a,b) ((a)<(b)?(a):(b))

/* Global variables */
long long tot_laps, change_time, base_round_time, tear_factor;


/*
    Returns the sum 0 + 1 + 2 + ... + n-1
 */
long long sum_from_zero_to_exclusive_formula(long long n) {
    return n * (n - 1) / 2;
}

// long long sum_from_zero_to_exclusive_execute(long long n) {
//     int sum = 0;
//     int i = n;
//     while (i > 0) sum += --i;
//     return sum;
// }

/*
    Returns the sum 0**2 + 1**2 + 2**2 + ... + (n-1)**2
 */
long long sum_of_squares_from_zero_to_exclusive_formula(long long n) {
    return n * (n - 1) * (2 * n - 1) / 6;
}

/*
    Returns the leap time given the number of laps in the leap.
    Calculate sum_{0 <= i < laps} r + b*i
 */
long long leap_time(long long laps) {
    return laps * base_round_time + tear_factor * sum_from_zero_to_exclusive_formula(laps);
}

/*
    Returns the total time given the minimum number of laps per leap
 */
long long total_time(long long laps_in_shortest_leap) {
    long long tot_leaps = tot_laps / laps_in_shortest_leap;
    long long long_leaps = tot_laps - tot_leaps * laps_in_shortest_leap;
    long long short_leaps = tot_leaps - long_leaps;

    long long time_in_short_leaps = short_leaps * leap_time(laps_in_shortest_leap);
    long long time_in_long_leaps = long_leaps * leap_time(laps_in_shortest_leap + 1);
    long long time_for_changing = (tot_leaps - 1) * change_time;

    return time_for_changing + time_in_short_leaps + time_in_long_leaps;
}

long long total_time_by_pitstops(long long pitstops) {
    long long tot_leaps = pitstops + 1;
    long long laps_in_shortest_leap = tot_laps / tot_leaps;
    return total_time(laps_in_shortest_leap);
}

/*
    Return the minimum time required to finish the race
 */
long long find_by_ternary_search_on_leap_length() {
    // Ternary search on length of shortest leaps
    // Both bounds are inclusive, i.e. the optimum could also be either one
    long long ub = tot_laps;
    long long lb = 1;

    // Keep the window sufficiently large such that we don't get tripped
    // by neighboring values that are equal
    while (ub - lb > 15) { 
        long long a_third = (ub - lb) / 3;
        long long lf = lb + a_third;
        long long rg = ub - a_third;
        long long left_ans = total_time(lf);
        long long right_ans = total_time(rg);
        if (left_ans <= right_ans) {
            ub = rg;
        }
        if (right_ans <= left_ans) {
            lb = lf;
        }
    }

    // When window is small enough, check every value therein.
    long long res = total_time(ub);
    for (int i = lb; i < ub; i++) res = min(res, total_time(i));
    return res;
}

// long long find_by_ternary_search_on_number_of_pitstops() {
//     // Bounds are inclusive
//     long long ub = tot_laps-1;
//     long long lb = 0;

//     // Keep the window sufficiently large such that we don't get tripped
//     // by neighboring values that are equal
//     while (ub - lb > 15) { 
//         long long a_third = (ub - lb) / 3;
//         long long lf = lb + a_third;
//         long long rg = ub - a_third;
//         long long left_ans = total_time_by_pitstops(lf);
//         long long right_ans = total_time_by_pitstops(rg);
//         if (left_ans <= right_ans) {
//             ub = rg;
//         }
//         if (right_ans <= left_ans) {
//             lb = lf;
//         }
//     }

//     // When window is small enough, check every value therein.
//     long long res = total_time_by_pitstops(ub);
//     for (int i = lb; i < ub; i++) res = min(res, total_time_by_pitstops(i));
//     return res;
// }

// long long brute_force_lap_length() {
//     res = total_time(1);

//     for (int min_laps_per_leap = 2; min_laps_per_leap <= tot_laps; min_laps_per_leap++) {
//         long long candidate = total_time(min_laps_per_leap);
//         if (candidate < res) res = candidate;
//         if (candidate > res) return res;
//     }

//     return res;
// }

// long long brute_force_pitstops() {
//     res = total_time_by_pitstops(0);

//     for (int pitstops = 1; pitstops < tot_laps; pitstops++) {
//         long long candidate = total_time_by_pitstops(min_laps_per_leap);
//         if (candidate < res) res = candidate;
//         if (candidate > res) return res;
//     }

//     return res;
// }

// long long brute_force_two_ways() {
//     res = total_time_by_pitstops(0);

//     for (int i = 0; i < tot_laps; i++) {
//         long long candidate_a = total_time_by_pitstops(i);
//         long long candidate_b = total_time(i+1);

//         long long candidate = min(candidate_a, candidate_b);
//         if (candidate < res) res = candidate;
//         if (candidate > res) return res;
//     }

//     return res;
// }

int main() {
    if (scanf("%lld %lld %lld %lld", &tot_laps, &change_time, &base_round_time, &tear_factor) != 4) return 5;

    long long ans = find_by_ternary_search_on_leap_length();
    if (printf("%lld\n", ans) <= 0) return 6;
    
    return 0;
}
