#include <iostream>

using namespace std;
#define min(a,b) ((a)<(b)?(a):(b))

/* Global variables */
long long tot_laps, change_time, base_round_time, tear_factor;

/*
    Returns the sum 0 + 1 + 2 + ... + n-1
 */
long long sum_from_zero_to_exclusive_formula(long long n) {
    return n * (n - 1) / 2;
}

/*
    Returns the leap time given the number of laps in the leap.
    Calculate sum_{0 <= i < laps} r + b*i
 */
long long leap_time(long long laps) {
    return laps * base_round_time + tear_factor * sum_from_zero_to_exclusive_formula(laps);
}

/*
    Returns the total time given the number of pit stops
 */
long long total_time_by_pitstops(long long pitstops) {
    long long runs = pitstops + 1;
    long long laps_in_shortest_runs = tot_laps / runs;
    long long long_runs = tot_laps % runs;
    long long short_runs = runs - long_runs;

    long long time_in_short_laps = short_runs * leap_time(laps_in_shortest_runs);
    long long time_in_long_laps = long_runs * leap_time(laps_in_shortest_runs + 1);
    long long time_for_changing = pitstops * change_time;
    return time_for_changing + time_in_short_laps + time_in_long_laps;
}

/*
    Try increasing amount of pit stops until it starts getting worse
 */
long long brute_force_pitstops() {
    long long res = total_time_by_pitstops(0);

    for (int pitstops = 1; pitstops < tot_laps; pitstops++) {
        long long candidate = total_time_by_pitstops(pitstops);
        if (candidate < res) res = candidate;
        if (candidate > res) return res;
    }

    return res;
}

int main() {
    if (scanf("%lld %lld %lld %lld", &tot_laps, &change_time, &base_round_time, &tear_factor) != 4) return 5;

    long long ans = brute_force_pitstops();
    printf("%lld\n", ans);
    
    return 0;
}
