#!/usr/bin/env python3
from accepted import brigtBiS
from time_limit_exceeded import brigtSlow
from random import randint

def run_tests():
    slow_solver = brigtSlow.BruteForceSolver()
    fast_solver = brigtBiS.SolverFast()


    for i in range(20):
        #laps, pit_time, base_time, tear_factor
        laps = randint(1,500000)
        pit_time = randint(1,1000)
        base_time = randint(1,1000)
        tear_factor = randint(1,1000)

        task_data = (pit_time,base_time, tear_factor, laps)
        print("start slow")
        s_pits, slow_result  = slow_solver.brute_force_search(task_data)
        print("end slow, start fast")
        f_pits, fast_result   = fast_solver.binary_search_non_req(0,laps-1, task_data)
        print("end fast O_O")

        if slow_result != fast_result:
            print(f"BIG NONO! laps:{laps}, pit_time:{pit_time}, base_time:{base_time}, tear_fact:{tear_factor} –– slow_result: {slow_result} s_pits: {s_pits} fast_result: {fast_result} f_pits: {f_pits}")
       
if __name__ ==  "__main__":
    run_tests()