#!/usr/bin/env python3
laps, change_time, core_round_time, tear_factor = map(int, input().split())

def sum_from_zero_to_exclusive_formula(n):
    """ Returns the sum 0 + 1 + 2 + ... + (n-1) """
    return n * (n - 1) // 2

def leap_time(laps):
    """ Returns the time it takes to complete the number of laps without changing tires """
    global core_round_time, tear_factor
    return laps * core_round_time + tear_factor * sum_from_zero_to_exclusive_formula(laps)

def total_time_by_tire_changes(tire_changes):
    """ Returns the total time with doing the provided number of tire changes """
    
    # A 'run' is some number of laps until changin tires again.
    runs = tire_changes + 1
    # Observation: It is always better to spread out changes as evenly
    # as possible, since the last lap in the run is most expensive.
    # Might not always be possible to distribute perfectly, so some runs
    # become one lap longer
    laps_per_run = laps // runs
    long_runs = laps % runs
    short_runs = runs - long_runs
    assert(short_runs*laps_per_run + long_runs*(laps_per_run + 1) == laps)
    time_short_run = leap_time(laps_per_run)
    time_long_run = leap_time(laps_per_run + 1)
    return short_runs * time_short_run + long_runs * time_long_run + change_time * tire_changes

def total_time_by_maxlaps_per_run(maxlaps_per_run):
    global laps
    runs = laps // maxlaps_per_run
    # If laps/minlaps_per_run is not integer, we should round up
    # (therefore adding minlaps_per_run - 1).
    #    Example: 5 laps, max 2 laps per run: 5/2 == 2.5 runs. Then runs are 1+2+2.
    #    Also note: run 1+1+1+2 does not make sense: either 1+1+1+1+1 or 1+2+2 must
    #    be at least as good.
    # Recall that the number of tire changes is one less than number of runs
    return min(total_time_by_tire_changes(runs), total_time_by_tire_changes(runs-1))

# We notice that # of tire changes * # laps per leaps = n
# Hence, we either have # of tire changes <= sqrt(n), OR # of laps per leap <= sqrt(n)
print(min(
    min(total_time_by_maxlaps_per_run(i) for i in range(1, min(laps, int(laps**0.5) + 3))) if laps > 1 else float('inf'),
    min(total_time_by_tire_changes(i) for i in range(0, min(laps, int(laps**0.5) + 3)))
))
