#!/usr/bin/env bash

MAXN=1000000000
MAXP=1000000000
MAXR=100
MAXB=4
SEED=1337
END=30

DESTINATION="../data/secret/generated"
rm -rf $DESTINATION
mkdir -p $DESTINATION

COUNT=0
generateran() {
    ((COUNT++))
    printf -v padCount "%02d" $COUNT
    echo "Generating case ${padCount}"
    ./generate.py -i $1 -n $2 -p $3 -r $4 -b $5 -s $SEED > $DESTINATION/${padCount}.in
}

generateman() {
    ((COUNT++))
    printf -v padCount "%02d" $COUNT
    echo "Manual case ${padCount} ($2)"
    echo $1 > $DESTINATION/${padCount}_manual_${2}.in
}

for n in $(seq 1 $END)
do
    generateran $n $MAXN $MAXP $MAXR $MAXB
    # ./generate.py -i $n -n $MAXN -p $MAXP -r $MAXR -b $MAXB -s $SEED > $DESTINATION/secret_$n.in
done

generateman "$MAXN 0 1 1" "changefast0"
generateman "$MAXN 1 1 1" "changefast1"
generateman "$MAXN 2 1 1" "changefast2"
generateman "$MAXN 10 1 0" "changefast10_b0"
generateman "$MAXN 10 1 1" "changefast10_b1"
generateman "$MAXN 10 1 2" "changefast10_b2"
generateman "$MAXN $MAXP 1 0" "changeslow_b0"
generateman "$MAXN $MAXP 1 1" "changeslow_b1"
generateman "$MAXN $MAXP 1 2" "changeslow_b2"
generateman "$MAXN $MAXP $MAXR $MAXB" "all_maxed"
generateman "$MAXN 1 $MAXR $MAXB" "changefast1_else_maxed"
generateman "$MAXN 10 $MAXR $MAXB" "changefast10_else_maxed"

for f in $DESTINATION/*.in
do
    echo "solving $f"
    ../submissions/accepted/brigtBiS.py < $f > ${f%???}.ans
done
