#!/usr/bin/env python3
import sys, argparse, random, math

def main():
    parser = argparse.ArgumentParser(description="Generator for the f1 racing problem.")
    parser.add_argument('-i', metavar='I', type=int, required=True, help='Counter')
    parser.add_argument('-n', metavar='N', type=int, required=True, help='Max rounds')
    parser.add_argument('-p', metavar='P', type=int, required=True, help='Pit stop time')
    parser.add_argument('-r', metavar='R', type=int, required=True, help='Base time')
    parser.add_argument('-b', metavar='B', type=int, required=True, help='Tear factor')
    parser.add_argument('-s', metavar='S', type=int, required=True, help='seed')

    args = parser.parse_args()

    random.seed(args.n+args.p+args.r+args.b+args.b+args.s+args.i)


    n = random.randint(1, args.n)
    p = random.randint(1, args.p)
    r = random.randint(0, args.r)
    b = random.randint(0, args.b)


    print(n, p, r, b)

def scale(val, n, fac):
    return val//math.pow(n,fac)

if __name__ == "__main__":
    main()
