#include <stdio.h>
#include <stdlib.h>
using namespace std;

#define rep(i,n) for(int i=0;i<(n);i++)
#define sf(n)       scanf("%d", &n)

int main() {
    // A O(n^2) solution to the price robot (hard) problem (Torstein)
    // This solution will preform poorly when input is strictly increasing,
    // i.e. 1 2 3 4 5 6 (...) (every day, BarGain score is infinity -- we
    // never shortcut the inner while loop below.)
    int n;
    sf(n);
    int *price = new int[n];
    int *ans = new int[n];

    int i = -1;
    while (++i < n)
    {
        sf(price[i]);
    }
    
    rep(i, n) {
        // Compute BarGain score for day i
        int p0 = price[i];
        int j = i;
        while (++j < n && price[j] > p0);
        ans[i] = j < n ? j - i : -1;
    }

    rep(i, n) {
        if (ans[i] < 0) fprintf(stdout, "infinity\n");
        else fprintf(stdout, "%d\n", ans[i]);
    }

    return 0;
}
