#!/usr/bin/env python3
from heapq import heappop, heappush
n, m, water_n, food_n = map(int, input().split())
hq = 0
water_locations = list(map(int, input().split()))
food_locations = list(map(int, input().split()))

# Step 0: Build the graph
adj_list = [[] for _ in range(n)]
for _ in range(m):
    a, b, w = map(int, input().split())
    adj_list[a].append((b, w))
    adj_list[b].append((a, w))

def dijkstra(s, graph):
    sp = {}
    pq = [(0, s)]
    while len(pq) > 0:
        c, u = heappop(pq)
        if u in sp:
            continue
        sp[u] = c
        for v, d in graph[u]:
            heappush(pq, (c + d, v))
    return sp

# Step 1: Calculate shortest path from HQ to every vertex
sp = dijkstra(hq, adj_list)

# Step 2: Extend the graph by adding vertex n (the source)
# and vertex n+1 (the sink). Add edges from source/to sink.
adj_list.extend([[(x, sp[x]) for x in water_locations], []])
for x in food_locations: adj_list[x].append((n+1, sp[x]))

# Step 3: Find shortest path from source to sink
sp = dijkstra(n, adj_list)
print(sp[n+1])
