import java.io.*;
import java.util.Scanner;
import java.util.StringTokenizer;

public class brigt_dp {
    public static void main(String[] args) {
        Scanner in = new Scanner(System.in);
        int n = in.nextInt();
        in.nextLine();

        // We don't know the fancy formula for this problem, but we can solve it using DP!
        /*
        If i-3, i-2, i-1 all is losing for the player leaving the money pile with this much left,
        i must be winning for the player leaving at i.
        Using DP we can build an array of target values.
        */
        int listSize = n+1;
        if (listSize < 5){
            listSize =5;
        }
        boolean[] winningIfYouReach = new boolean[listSize]; // now idx 1 can be nr coins at one.
        winningIfYouReach[1] = true; // Zhivago has to pick this
        winningIfYouReach[2] = false;// Zhivago picks 1
        winningIfYouReach[3] = false;// Zhivago picks 2
        winningIfYouReach[4] = false;// Zhivago picks 3
        for (int i = 5; i < n; i++) {
            winningIfYouReach[i] = !(winningIfYouReach[i-1] || winningIfYouReach[i-2] || winningIfYouReach[i-3]);
        }

        // Interact with Zhivago
        // We look for what move makes us win, and pick that.
        boolean done = false;
        while (!done){
            if(winningIfYouReach[n-1]){
                System.out.println(1);
                System.out.flush();
                n -= 1;
            } else if(winningIfYouReach[n-2]){
                System.out.println(2);
                System.out.flush();
                n -= 2;
            } else {
                System.out.println(3);
                System.out.flush();
                n -= 3;
            }

            String zhivago = in.nextLine();
            if(zhivago.equals("I give up")){
                done = true;
            } else {
                int num = Integer.parseInt(zhivago);
                n -= num;
            }
        }
    }
}


/**

Used for speed improvement
*/

class KattioCoin extends PrintWriter {
    public KattioCoin(InputStream i) {
        super(new BufferedOutputStream(System.out));
        r = new BufferedReader(new InputStreamReader(i));
    }
    public KattioCoin(InputStream i, OutputStream o) {
        super(new BufferedOutputStream(o));
        r = new BufferedReader(new InputStreamReader(i));
    }

    public boolean hasMoreTokens() {
        return peekToken() != null;
    }

    public int getInt() {
        return Integer.parseInt(nextToken());
    }

    public double getDouble() {
        return Double.parseDouble(nextToken());
    }

    public long getLong() {
        return Long.parseLong(nextToken());
    }

    public String getWord() {
        return nextToken();
    }



    private BufferedReader r;
    private String line;
    private StringTokenizer st;
    private String token;

    private String peekToken() {
        if (token == null)
            try {
                while (st == null || !st.hasMoreTokens()) {
                    line = r.readLine();
                    if (line == null) return null;
                    st = new StringTokenizer(line);
                }
                token = st.nextToken();
            } catch (IOException e) { }
        return token;
    }

    private String nextToken() {
        String ans = peekToken();
        token = null;
        return ans;
    }
}
