#include <utility>
#include <string>
#include <cassert>
#include <cstring>
#include <cmath>
#include "validate.h"

using namespace std;

void play() {

    string line;
    assert(getline(judge_in, line));

    int n = -1;
    sscanf(line.c_str(), "%d", &n);
    judge_message("The current total of coins are %d\n", n);

    // Prints starting amount so that the player can do the first move
    cout << n << endl;

    while (true) {
        int taken;

        // checks to see if the player moves are illegal
        if (!(author_out >> taken)) {
            wrong_answer("Move %d: couldn't read an integer\n");
        }
        if (taken < 1 || taken > 3) {
            wrong_answer("Move %d is out of range: %d\n", taken);
        }
        judge_message("Player move is %d\n", taken);

        // updates the coin total based on the player move
        n = n - taken;

        if (n < 1) {
            wrong_answer("Player took the last coin\n");
        }

        // Formula to find out how many coins is optimal to take
        int order = int(ceil(n / 4.0));
        int remainder = 1 + ((order - 1) * 4);
        int bot_move = n - remainder;

        // If there is an optimal move the bot does it
        if (bot_move != 0) {
            judge_message("Bot made move %d on coins %d\n", bot_move, n);
            n = n - bot_move;
            cout << bot_move << endl;
            cout.flush();

        // Otherwise it will do a random move
        } else {
            bot_move = rand() % 3 + 1;
            n = n - bot_move;
            judge_message("Bot made move %d on coins %d\n", bot_move, n);
            // if the move made the bot lose the game it will accept the solution
            if (n < 1) {
                cout << "I give up" << endl;
                cout.flush();
                return;
            }
            cout << bot_move << endl;
            cout.flush();
        }
    }

    return;
}

int main(int argc, char **argv) {

    init_io(argc, argv);

    // Sets a seed for the randomizer
    // Can change to be input specific
    srand(13151719);

    play();

    /* Yay! */
    accept();
}
