#!/usr/bin/env python3
from collections import deque
from sys import exit

n, m, k = [int(x) for x in input().split()]
n += 1 # Adding node 0 as "outside"
targets = tuple(sorted([int(x) for x in input().split()]))
edges = [tuple(map(int, input().split())) for _ in range(m)]

adj_list = [[i] for i in range(n)]
for u, v in edges:
    adj_list[u].append(v)
    adj_list[v].append(u)

## A "configuration" is a sorted k-tuple (u1, u2, ..., uk), the locations
## of the bombs in the graph. Two configurations are neighbours if there
## exists a distinct set of movements e1, e2, ..., ek' (with k' < k) such
## that it is possible to move one bomb along each of those edges to obtain 
## one configuration from the other.

def get_neighbour_configurations(config):
    nbrs = set()

    def recursive_choice(bomb, partial_choice, edges_used, config): 
        if bomb == len(config):
            nbrs.add(tuple(sorted(partial_choice)))
            return

        current_location = config[bomb]
        for i, next_location in enumerate(adj_list[current_location]):
            if (current_location, i) not in edges_used:
                partial_choice.append(next_location)
                if (next_location != current_location): edges_used.add((current_location, i))
                recursive_choice(bomb + 1, partial_choice, edges_used, config)
                if (next_location != current_location): edges_used.remove((current_location, i))
                partial_choice.pop()

    recursive_choice(0, [], set(), config)
    return nbrs

# print(get_neighbour_configurations(tuple([0]*k)))
# print(list(sorted(get_neighbour_configurations((0,0,0,1,2)))))

dist_from_source = {tuple([0]*k): 0}
dist_from_sink = {targets: 0}
queue_source = deque()
queue_source.append(tuple([0]*k))
queue_sink = deque()
queue_sink.append(targets)

bestdist = float('inf')
while True:
    for q, dist_q, dist_o in [(queue_source, dist_from_source, dist_from_sink),
                                (queue_sink, dist_from_sink, dist_from_source)]:
        config = q.popleft()
        if config in dist_from_source and config in dist_from_sink:
            bestdist = dist_from_sink[config] + dist_from_source[config]
            for cf in queue_source:
                if cf in dist_from_sink:
                    bestdist = min(bestdist, dist_from_sink[cf] + dist_from_source[cf])
            print(bestdist)
            exit()

        for next_config in get_neighbour_configurations(config):
            if next_config in dist_o:
                bestdist = min(bestdist, dist_q[config] + 1 + dist_o[next_config])
            if next_config not in dist_q:
                dist_q[next_config] = dist_q[config] + 1
                q.append(next_config)
