#!/usr/bin/env python3
from collections import deque
n, d = map(int, input().split())
d_squared = d*d
islands = [tuple(map(int, input().split())) for _ in range(n)]

## Function for calculating the square distance. The benefit of working
## with the square distance is that we don't need to worry about floating
## point issues (rounding errors etc)
def sq_dist(a, b):
    return (a[0]-b[0])*(a[0]-b[0]) + (a[1]-b[1])*(a[1]-b[1])

## Build an adjacency list 
adj_list = [[] for _ in range(n)]
for a in range(n):
    for b in range(a + 1, n):
        if sq_dist(islands[a], islands[b]) <= d_squared:
            adj_list[a].append(b)
            adj_list[b].append(a)

## We explore the graph with BFS. groupname is a map from EVERY vertex to its
## group name; that name happens to be the first vertex that was explored in
## its group. The presence of a vertex in the map acts as a visited/enqueued flag.
groupname = {}

## Groupsize is only defined for the group name (i.e. first vertex in group).
## To access the group size of vertex u, look up groupsize[groupname[u]]
groupsize = {}

for i in range(n):
    if i in groupname:
        continue

    groupname[i] = i
    queue = deque([i])
    size = 1
    while len(queue) > 0:
        u = queue.popleft()
        for v in adj_list[u]:
            if v not in groupname:
                groupname[v] = i
                queue.append(v)
                size += 1
    
    groupsize[i] = size

## Assertions are not necessary, but helpful for debugging
assert(sum(groupsize.values()) == n)
for i in range(n):
    assert(i in groupname.keys())
    assert(groupname[i] in groupsize)

## Printing for debugging
# for g in groupsize:
#     print(g+1, groupsize[g], sorted([x+1 for x in range(n) if groupname[x] == g]))
#     if groupsize[g] == 2: 
#         dots = list(islands[i] for i in range(i) if groupname[i] == g)
#         print(dots, sq_dist(dots[0], dots[1]))

## Note: prints the elements in order of decreasing utility, but not "group by group".
print(" ".join(map(lambda y: str(y + 1), sorted(range(n), key=lambda x: (-groupsize[groupname[x]], x)))))
