#!/usr/bin/env python3
import math, sys
from collections import defaultdict
sys.setrecursionlimit(5000)

n, d = map(int, input().split())

coordinates = []
for i in range(n):
    x, y = map(int, input().split())
    coordinates.append([x, y])

def dist(i1, i2):
    x1, y1 = coordinates[i1]
    x2, y2 = coordinates[i2]
    return math.sqrt((x1-x2)**2 + (y1-y2)**2)

def dfs(si, visisted, mark, marks):
    visisted.add(si)
    marks[mark].append(si)
    for ti in range(n):
        if ti not in visisted and dist(si, ti) <= d:
            dfs(ti, visisted, mark, marks)

mark = 0
marks = []
visited = set()
for i in range(n):
    if i not in visited:
        marks.append([])
        dfs(i, visited, mark, marks)
        mark += 1

marks.sort(key=lambda x: len(x), reverse=True)

print(" ".join([" ".join([str(i + 1) for i in group]) for group in marks]))