#!/usr/bin/env python3
from sys import stdin
import sys
import re
integer = "(0|-?[1-9]\d*)"

entry = stdin.readline().split()
assert len(entry) == 2
n, d = entry
assert re.match(integer, n)
if len(n) > 1:
    assert(n[0] != '0')

assert re.match(integer, d)
if len(d) > 1:
    assert(d[0] != '0')

# distance not negative
assert d[0] != "-"

islands = []

for i in range(int(n)):
    island = stdin.readline().split()
    assert len(island) == 2

    x, y = island
    assert re.match(integer, x)
    if len(x) > 1:
        assert(x[0] != '0')

    assert re.match(integer, y)
    if len(y) > 1:
        assert(y[0] != '0')
    
    islands.append((x, y))

assert(len(islands) == len(set(islands)))

line = stdin.readline()
assert len(line) == 0

# Nothing to report
sys.exit(42)
