#!/usr/bin/env python3
import sys, argparse, random, math

def main():
    parser = argparse.ArgumentParser(description="Generator for 100mdash problem giving small distances between points.")
    parser.add_argument('-i', metavar='I', type=int, required=True, help='iteration')
    parser.add_argument('-t', metavar='T', type=int, required=True, help='T increase')
    parser.add_argument('-p', metavar='P', type=int, required=True, help='max points')
    parser.add_argument('-x', metavar='X', type=int, required=True, help='max X value')
    parser.add_argument('-y', metavar='Y', type=int, required=True, help='max Y value')
    parser.add_argument('-s', metavar='S', type=int, required=True, help='seed')

    args = parser.parse_args()
    random.seed(args.i+args.t+args.p+args.p+args.x+args.y+args.s)
    number_of_ns = args.p
    time = 0
    dataToBePrinted = []
    distance = 200/number_of_ns

    for i in range(number_of_ns):
        x = i*distance
        y = 0
        t = random.randint(1,args.t)
        time += t
        dataToBePrinted.append((x,y,time))
    # time += 100000000
    #dataToBePrinted.append((200, 200, time))
    """for i in range(number_of_ns):
        x = 100-i*distance
        y = 300
        t = random.randint(1,args.t)
        time += t
        dataToBePrinted.append((x,y,time))
    """
    print(len(dataToBePrinted))
    for (x,y,time) in dataToBePrinted:
        f_x = "{:.6f}".format(x)
        f_y = "{:.6f}".format(y)
        f_time = "{:.6f}".format(time)
        print(f_x, f_y, f_time)




if __name__ == "__main__":
    main()
