#!/usr/bin/env python3

n = int(input())
peopl = [int(x) for x in input().split()] # Hold # of passengers in segment
order = [int(x) - 1 for x in input().split()]

maxchaos = 0
segments = 0
alive = [False] * (n+1) # Last entry always False so we can ignore outofbounds

islands = list(range(n))
weights = [1] * n

def find(a):
    global islands
    if islands[a] == a:
        return a
    islands[a] = find(islands[a])
    return islands[a]
    
def union(a, b):
    global islands, weights
    a = find(a)
    b = find(b)
    if (a != b):
        if weights[a] < weights[b]:
            islands[a] = b
            weights[b] += weights[a]
            peopl[b] += peopl[a]
        else:
            islands[b] = a
            weights[a] += weights[b]
            peopl[a] += peopl[b]
            
def roundup(a):
    # Round up to nearest 10
    return a if a % 10 == 0 else a + 10 - (a % 10)

base_chaos = 0 ## sum of round_up(number of passengers) for each segment
while len(order) > 0:
    i = order.pop()
    alive[i] = True
    base_chaos += roundup(peopl[i])
    segments += 1
    
    for j in [i-1, i+1]:
        if alive[j]:
            base_chaos -= roundup(peopl[find(i)])
            base_chaos -= roundup(peopl[find(j)])
            union(i, j)
            segments -= 1
            base_chaos += roundup(peopl[find(i)])
    maxchaos = max(maxchaos, base_chaos * segments)
    
print(maxchaos)