import sys, heapq
INF = float('inf')

#Initial
n, m = [int(x) for x in raw_input().split()]
a, b, c = [int(x) for x in raw_input().split()]
n += 1
capacity = [ [0]*n for i in range(n)]
edges = [[] for _ in range(n)]
adjlis = edges

for i in range(m):
	u, v, x = [int(z) for z in raw_input().split()]
	capacity[u][v] = 2*x
	capacity[v][u] = 2*x
	edges[u].append(v)
	edges[v].append(u)

high = sum(capacity[b]) + sum(capacity[c])
low = 0

edges[0].append(b)
edges[0].append(c)

#Compute flow
def compute_flow(s, t):
	n = len(capacity)
	F = [ [capacity[i][j] for j in range(n)] for i in range(n)]
	visited = [False]*n

	def dfs(u, treshold):
		if visited[u]:
			return 0;
		elif u == t:
			return treshold
		visited[u] = True
		flow = 0
		for v in edges[u]:
			if flow == treshold:
				break
			if F[u][v] > 0:
				f = dfs(v, min(F[u][v], treshold - flow))
				F[u][v] -= f
				F[v][u] += f
				flow += f
		if flow == treshold:
			visited[u] = False
		return flow
	
	total_flow = 0
	while (True):
		visited = [False]*n
		flow = dfs(s, INF)
		if flow <= 0:
			break
		total_flow += flow
	
	return total_flow

#Binary search for answer
while low + 1 < high:
	med = (low + high) / 2
	capacity[0][b] = med
	capacity[0][c] = med
	result = compute_flow(0, a)
	if (result == 2*med):
		low = med
		#print low
	else:
		high = med
		#print str(high) + "!"
print low
