#!/usr/bin/env python3
NON = 0
PRE = 1
MID = 2

n = int(input())
graph = [[] for _ in range(n)]

for _ in range(n-1):
    a, b = [int(x) for x in input().split()]
    graph[a].append(b)
    graph[b].append(a)
    
## Root the tree at node 0, place half its neighbours on left, half on right.
## Do this "recursively" until all are placed.

q = [(0, True)]
enqueued = [NON] * n
enqueued[0] = PRE

order = []

while len(q) > 0:
    u, parent_on_right = q.pop()
    
    if enqueued[u] == PRE:
        
        # Half the children to left, half to right
        left = []
        right = []
        nextLeft = True if parent_on_right else False
        for nb in graph[u]:
            if enqueued[nb] == NON:
                if nextLeft:
                    left.append((nb, True))
                else:
                    right.append((nb, False))
                nextLeft = not nextLeft
                enqueued[nb] = PRE
        
        while len(right) > 0:
            q.append(right.pop())
            
        q.append((u, parent_on_right))
        enqueued[u] = MID
        
        while len(left) > 0:
            q.append(left.pop())
            
    elif enqueued[u] == MID:
        order.append(u)
            
    
print(" ".join(str(x) for x in order))
