#!/usr/bin/env python2
import sys

args = sys.argv
data = list(open(args[1]))

#read input and compute best possible imbalance = #vertices with odd degree
n = int(data[0])
edges = [ [] for i in range(n)]
for line in data[1:]:
	u, v = map(int, line.split())
	edges[u].append(v)
	edges[v].append(u)
true_res = len(filter(lambda x: len(x) % 2 == 1, edges))
    

data = sys.stdin.readlines()

# Only data on first line
for line in data[1:]:
    if line != "":
        sys.exit(43)
        
# There is first line
if len(data) <= 0:
    sys.exit(43)
        
# Correct number of tokens
line = data[0].split()
if len(line) != n:
    sys.exit(43)
    
# All tokens are integers
for token in line:
    try:
        int(token)
    except:
        sys.exit(43)
        
# All tokens are in range 0 ... n-1
for token in line:
    if int(token) < 0 or int(token) >= n:
        sys.exit(43)
        
# Each token once
visited = [False] * n
for token in line:
    visited[int(token)] = True
for seen in visited:
    if not seen:
        sys.exit(43)



visited = [False] * n
#compute imbalance of computed ordering
res = 0
for token in line:
	u = int(token)
	if visited[u]:
		sys.exit(43) #ordering contains some vertex several times
	visited[u] = True
	l = 0
	for v in edges[u]:
		if visited[v]:
			l += 1
		else:
			l -= 1
	res += abs(l)

#check that imbalance of ordering matches optimal
# print(str(res) + " " + str(true_res), sys.stderr)
if res == true_res:
    # print res
	sys.exit(42)
else:
	sys.exit(43)
