#!/usr/bin/env python3
import sys, argparse, random
# Generate a single testcase for period ticket

parser = argparse.ArgumentParser(description="Generator for period ticket.")
parser.add_argument('-o', metavar='O', type=str, default="random",
                    help='Options for generation (random, evenly, burtsy)')
parser.add_argument('-n', metavar='N', type=int, default=50,
                    help='number of trips')
parser.add_argument('-s', metavar='S', type=int, default=38,
                    help='price single ticket')
parser.add_argument('-p', metavar='P', type=int, default=780,
                    help='price of period ticket')
parser.add_argument('-m', metavar='M', type=int, default=30,
                    help='duration of period ticket')
parser.add_argument('-r', metavar='R', type=int, default=100,
                    help='range of dates')
parser.add_argument('-seed', metavar='SEED', type=int, default=None,
                    help='seed for generation (optional)')
args = parser.parse_args()
random.seed(args.seed)

options = args.o
s, p, m, n, r = args.s, args.p, args.m, args.n, args.r


## 
trips = []
if "evenly" in options:
    trips = [i * r // n for i in range(n)]

else:
    #Random
    trips = [random.randrange(0, r) for _ in range(n)]
    
print(s, p, m, len(trips))
print(" ".join(map(str, sorted(trips))))