package util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.*;

public class Graph {
    private int v = 0, e = 0;
    //private HashMap<Integer, HashMap<Integer, Integer>> g;
    private int[][] g;
    private final int INF = Integer.MAX_VALUE / 2;

    public Graph(int v) {
        this.v = v;
        g = new int[v][v];
        for (int i = 0; i < v; i++) {
            Arrays.fill(g[i], INF);
        }
    }

    /**
     * @param file location of the file of the util
     * @return a Graph object which contain all vertices and edges from the
     * file.
     */
    public static Graph readFile(String file) {
        Scanner sc;
        try {
            File f = new File(file);
            sc = new Scanner(new FileReader(f));
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }

        sc.next();
        sc.next();
        int v = sc.nextInt();
        int e = sc.nextInt();
        Graph g = new Graph(v);
        for (int i = 0; i < e; ++i) {
            sc.next();
            int a = sc.nextInt();
            int b = sc.nextInt();
            int w = sc.nextInt();
            g.addUndirected(a, b, w);
        }
        sc.close();
        return g;
    }

    /*public Graph clone() {
        Graph graph = new Graph(v);
        Set<Integer> vertices = getVertices();
        for (int vertex : vertices) {
            HashMap<Integer, Integer> map = g.get(vertex);
            for (Map.Entry<Integer, Integer> e : map.entrySet()) {
                graph.addDirected(vertex, e.getKey(), e.getValue());
            }
        }
        return graph;
    }*/

    public void addUndirected(Edge e) {
        addUndirected(e.getFrom(), e.getTo(), e.getWeight());
    }

    public void addDirected(int from, int to, int weight) {
        if (!edgeExists(from, to)) {
            e++;
        }
        g[from][to] = weight;
    }

    public void addUndirected(int from, int to, int weight) {
        addDirected(from, to, weight);
        addDirected(to, from, weight);
    }

    public boolean edgeExists(int from, int to) {
        return g[from][to] != INF;
    }

    public int getWeight(int from, int to) {
        return g[from][to];
    }

    public int getAmountOfVertices() {
        return v;
    }

    public int getAmountOfEdges() {
        return e;
    }

    public double getDensity() {
        return (double) e / (v * (v - 1));
    }
    
    /*public double getUndirectedDensity() {
        return 2.0*e/(v*(v-1));
    }*/

    /**
     * Checks if the util is empty
     *
     * @return true iff the util contains no edges
     */
    public boolean isEmpty() {
        return e == 0;
    }

    public Matrix getAdjacencyMatrix() {
        int n = getAmountOfVertices();
        Matrix output = new Matrix(n, n);
        for (int i = 0; i < v; i++) {
            for (int j = 0; j < v; j++) {
                if (edgeExists(i, j)) {
                    output.setElement(i + 1, j + 1, 1);
                }
            }
        }
        return output;
    }

    public int[][] makeDists() {
        return g;
    }

    public void printToFile(String name) throws IOException {
        FileWriter fw = new FileWriter(new File("../instances/" + name + ".in"));
        fw.write(v + " " + (e / 2) + "\n");
        for (int i = 0; i < v; i++) {
            for (int j = 0; j < v; j++) {
                if (edgeExists(i, j)) {
                    int w = getWeight(i, j);
                    if (i < j) {
                        fw.write((i + 1) + " " + (j + 1) + " " + w + "\n");
                    }
                }
            }
        }
        fw.close();
    }
}

