#include <iostream>
#include <math.h>
#include <vector>
#include <iomanip>
using namespace std;

int main() {
    int n; cin >> n;
    vector<int> x(n),r(n);
    for(int i=0;i<n;++i) cin >> x[i] >> r[i];

    auto f = [&](double t) {
        double h = 0;
        for(int i=0;i<n;++i) {
            auto dif = abs(t-x[i]);
            if(dif<r[i]) {
                h = max(h,sqrt(r[i]*r[i]-dif*dif));
            }
        }
        return h;
    };

    const int steps = 6e6+1; // steps has to be odd
    const double eps = 40./steps;
    // use Simpson's rule for better convergence
    double res=f(-20)+f(20);
    for(int i=1;i<steps;++i) {
        auto t = -20+(eps*i);
        res+=f(t)*(i%2==1?4:2);
    }
    res*=eps*2/3;
    cout << setprecision(15) << res << '\n';
}