import kotlin.math.*

fun main() {
  val input = System.`in`.bufferedReader()
  val numberOfCircles = input.readLine().toInt()
  val circles = input.lineSequence().take(numberOfCircles)
    .map { line -> line.split(" ").map { it.toDouble() } }
    .mapIndexed { index, (a, b) -> Circle(index, a, b) }
    .toList()
  // Determine which circles are  outside the polygon
  val notContained = BooleanArray(numberOfCircles) { true }
  circles.forEach { outer ->
    circles.forEach { inner ->
      if (notContained[outer.label] && inner in outer) {
        notContained[inner.label] = false
      }
    }
  }
  val relevant = circles.filter { notContained[it.label] }
  println(relevant.area())
}

fun List<Circle>.area(): Double {
  var ans = 0.0
  forEach { circle ->
    val intersections = mutableListOf<Point>()
    forEach { other ->
      if (circle.label != other.label && circle intersect other) {
        val (p1, p2) = circle.intersectionPoints(other)
        var theta1 = radialAngle(p1.x() - circle.x, p1.y())
        var theta2 = radialAngle(p2.x() - circle.x, p2.y())
        if (theta1 > theta2) {
          val temp = theta2
          theta2 = theta1
          theta1 = temp
        }
        if ((other.x - circle.x - circle.radius * cos((theta1 + theta2) / 2.0)).pow(2)
          + (-circle.radius * sin((theta1 + theta2) / 2)).pow(2) < other.radius.pow(2)
        ) {
          intersections.add(theta1 to theta2)
        } else if (
          (other.x - circle.x - circle.radius * cos((theta1 + theta2) / 2.0 + PI)).pow(2)
          + (-circle.radius * sin((theta1 + theta2) / 2 + PI)).pow(2) < other.radius.pow(2)
        ) {
          intersections.add(theta2 to 2*PI)
          intersections.add(0.0 to theta1)
        }
      }
    }
    if (intersections.isEmpty()) {
      ans += PI * circle.radius.pow(2)
    } else {
      // find all the sections of the circle that are on the outside of the polygon
      val sorted = intersections.sortedWith { o1, o2 ->
        when (o1.x()) {
          o2.x() -> o1.y().compareTo(o2.y())
          else -> o1.x().compareTo(o2.x())
        }
      }
      var (theta1, theta2) = sorted.first()
      val limits = mutableListOf<Point>(0.0 to theta1)
      var j = 0
      while (j in sorted.indices) {
        while (j in sorted.indices && theta2 > sorted[j].x()) {
          theta2 = max(sorted[j].y(), theta2)
          j++
        }
        if (j in sorted.indices) {
          limits.add(theta2 to sorted[j].x())
          theta1 = sorted[j].x()
          theta2 = sorted[j].y()
        }
        j++
      }
      limits.add(theta2 to 2 * PI)
      limits.filter { (start, end) ->
        !(start == 0.0 && end == 2 * PI) && (start != end)
      }.forEach { (start, end) ->
        ans += circle.thetaArea(end) - circle.thetaArea(start)
      }
    }
  }
  return ans
}

typealias Point = Pair<Double, Double>

fun Point.x() = first
fun Point.y() = second

data class Circle(
  val label: Int,
  val x: Double,
  val radius: Double
) {
  operator fun contains(other: Circle): Boolean {
    if (label == other.label) {
      return false
    }
    return sqrt((x - other.x).pow(2) + other.radius.pow(2)) <= radius
  }

  infix fun intersect(other: Circle): Boolean {
    val distance = sqrt((x - other.x).pow(2))
    return !(distance > (radius + other.radius) || abs(radius - other.radius) >= distance)
  }

  fun intersectionPoints(other: Circle): Pair<Point, Point> {
    val a = 2.0 * (other.x - x)
    val b = 0.0
    val c = radius.pow(2) - other.radius.pow(2) + other.x.pow(2) - x.pow(2)
    val (y1, y2) = solveQuadratic(1.0, -2.0, 1.0 + (c / a - x).pow(2) - radius.pow(2))
    val x1 = c / a
    return (x1 to y1 - 1.0) to (x1 to y2 - 1.0)
  }

  fun thetaArea(theta: Double) =
    radius * (x * sin(theta)) + radius.pow(2) * (theta + sin(theta) * cos(theta)) * 0.5

}

fun solveQuadratic(a: Double, b: Double, c: Double): Pair<Double, Double> {
  val d = sqrt(b.pow(2) - 4 * a * c)
  return (-b - d) / (2 * a) to (-b + d) / (2 * a)
}

fun radialAngle(x: Double, y: Double) = when {
  x > 0.0 && y == 0.0 -> 0.0
  x > 0.0 && y > 0.0 -> atan(y / x)
  x == 0.0 && y > 0.0 -> PI / 2
  x < 0.0 && y > 0.0 -> PI - atan(abs(y / x))
  x < 0.0 && y == 0.0 -> PI
  x < 0.0 && y < 0.0 -> PI + atan(abs(y / x))
  x == 0.0 && y < 0.0 -> 1.5 * PI
  x > 0.0 && y < 0.0 -> 2 * PI - atan(abs(y / x))
  else -> 0.0
}
