// @EXPECTED_RESULTS@: RUN_TIME_ERROR, WRONG_ANSWER
import java.util.PriorityQueue
import kotlin.math.max

fun main() {
  val input = System.`in`.bufferedReader()
  val (segments, breaths) = input.readLine().split(" ").map { it.toInt() }
  var time = 0L
  val song = input.lineSequence().mapIndexed { index, line ->
    val (pitch, length) = line.split(" ").map { it.toLong() }
    Segment(index, pitch, length, time).also { time += it.length }
  }.toList()

  val breathingOptions =
    song.windowed(3)
      .filter { (a, b, c) -> a.pitch > b.pitch && b.pitch < c.pitch }
      .map { (_, it) -> it }
  if (breathingOptions.size <= breaths) {
    return println(song.maxTimeWithoutBreading(breathingOptions.map { it.position }.toSet()))
  }
  val idealBreathRythm = time.toDouble() / (breaths + 1)
  println(idealBreathRythm)
  println(breathingOptions)
  val breathBrakes = mutableSetOf<Int>()
  val optionsMap = (1..breaths).associate { breath ->
    breath to (breathingOptions.last { it.time <= breath * idealBreathRythm } to breathingOptions.first { it.time > breath * idealBreathRythm })
  }
  println(optionsMap)
  println(song.maxTimeWithoutBreading(breathBrakes))
  // TODO: Figure out maximum breathing

}

fun List<Segment>.maxTimeWithoutBreading(breaths: Set<Int>): Long {
  var max = 0L
  max = max(max, fold(0L) { acc, segment ->
    val next = acc + segment.length
    when (segment.position) {
      in breaths -> {
        max = max(max, acc)
        0
      }
      else -> next
    }
  })
  return max
}


data class Segment(val position: Int, val pitch: Long, val length: Long, val time: Long)
