import java.util.PriorityQueue

fun main() {
  val input = System.`in`.bufferedReader()
  val (width, height) = input.readLine().split(" ").map { it.toInt() }
  val map = input.lineSequence()
    .map { line ->
      line.map {
        when (it) {
          '_' -> true
          else -> false
        }
      }.toList()
    }.toList()
  // The following line is magic to speed things up
  if (map.any { row -> row.all { !it } }) return println("impossible")
  val queue = PriorityQueue<Pair<Coordinate, List<String>>> { o1, o2 -> o2.first.y.compareTo(o1.first.y) }
  (0 until width).map { Coordinate(it, 0) }.filter { map.isPassable(it) }.map { it to listOf("${it.x + 1}") }
    .toCollection(queue)
  val seen = mutableSetOf<Coordinate>()
  while (queue.isNotEmpty()) {
    val (location, path) = queue.poll()
    if (location.y == height - 1) {
      return path.print()
    }
    // Left forward
    var next = location.plusY(1).plusX(-1)
    if (location.x > 0 && map.isPassable(next) && seen.add(next)) {
      queue.add(next to path + listOf("L"))
    }
    // Right forward
    next = location.plusY(1).plusX(1)
    if (location.x < width - 1 && map.isPassable(next) && seen.add(next)) {
      queue.add(next to path + listOf("R"))
    }
    // Single forward
    next = location.plusY(1)
    if (map.isPassable(next) && seen.add(next)) {
      queue.add(next to path + listOf("F"))
    }
  }
  println("impossible")
}

fun List<String>.print() {
  println(first())
  println(drop(1).joinToString(""))
}

fun List<List<Boolean>>.isPassable(coordinate: Coordinate) =
  when (coordinate.y) {
    in indices -> get(coordinate.y)[coordinate.x]
    else -> true
  }

data class Coordinate(val x: Int, val y: Int) {
  fun plusY(value: Int) = copy(y = y + value)
  fun plusX(value: Int) = copy(x = x + value)
}
