package F;
/*
DIT IS VAN TEAM PHOENIX!
 */


import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.*;

public class Phoenix {
    public static void main(String[] args) throws Exception {
//        BufferedReader bf = new BufferedReader(new FileReader(new File("/home/contestant/samples/F/1.in")));
        BufferedReader bf = new BufferedReader(new InputStreamReader(System.in));
        solve(bf);
    }
    public static void solve(BufferedReader bf) throws Exception{
        String[] l = bf.readLine().split(" ");
        int n = Integer.parseInt(l[0]);
        int m = Integer.parseInt(l[1]);
        boolean[][] maze = new boolean[n][m+2];

        for (int y = 0; y < n; y++) {
            char[] line = bf.readLine().toCharArray();
            for (int x = 1; x <= m; x++) {
                maze[y][x] = line[x - 1] == '_';
            }
        }

        if (!bfs(maze, n)) {
            System.out.println("impossible");
        }
    }

    public static boolean bfs(boolean[][] maze, int n) {
        Queue<Tuple> q = new LinkedList<>();
        for (int x = 1; x <= maze[0].length - 1; x++) {
            if (maze[0][x]) q.add(new Tuple(x, 0));
        }
        Map<Tuple, Tuple> prev = new HashMap<>();

        while (!q.isEmpty()) {
            Tuple pos = q.poll();
            if (pos.y == n-1) {
                StringBuilder ans = new StringBuilder();
                while (pos.y > 0) {
                    Tuple prevTuple = prev.get(pos);
                    if (prevTuple.x < pos.x) {
                        ans.append("R");
                    } else if (prevTuple.x == pos.x) {
                        ans.append("F");
                    } else {
                        ans.append("L");
                    }
                    pos = prevTuple;
                }
                System.out.println(pos.x);
                System.out.println(ans.reverse().toString());
                return true;
            }
            for (int x = pos.x-1; x <= pos.x+1; x++) {
                Tuple neigh = new Tuple(x, pos.y+1);
                if (maze[pos.y+1][x] && !prev.containsKey(neigh)) {
                    q.add(neigh);
                    prev.put(neigh,pos);
                }
            }
        }
        return false;
    }

    static class Tuple {
        int x;
        int y;

        public Tuple(int x, int y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            Tuple tuple = (Tuple) o;
            return x == tuple.x && y == tuple.y;
        }

        @Override
        public int hashCode() {
            return Objects.hash(x, y);
        }
    }
}
