#include "validation.h"
#include <string>

// The answer is either "impossible", or an integer (starting lane) followed by a string (directions).
// This validator checks whether the given directions follow a valid path through the spikefield.

int main(int argc, char **argv) {
    // Set up the input and answer streams.
    std::ifstream in(argv[1]);
    std::ifstream ans(argv[2]); // Only for custom checker.
    OutputValidator v(argc, argv);

    int n, m;
    in>>n;
    in>>m;
    std::string spikefield[n];

    for(int i = 0; i < n; i ++)
    {
        in>>spikefield[i];
    }

    std::string expected;
    ans >> expected;

    if(expected == "impossible"){
        v.test_string("impossible");
        v.newline();
    } else {

        int startingPosition = v.read_integer("startingPosition", 1, 1000) - 1;
        v.newline();
        std::string directions = n > 1 ? v.read_string("directions", n - 1, n - 1, "FLR") : "";
        v.newline();



        if(startingPosition >= m) v.check(false, "value ", startingPosition, " exceeds the index of the last lane");

        int currentPosition = startingPosition;

         if(spikefield[0] [currentPosition] == '*') v.check(false, "Shonic has hit a spike in row ", 0, " lane ", currentPosition);

        for(int i = 0; i < n - 1; i++)
        {
            bool flag = 0;
            if(directions[i] == 'L')
            {
                currentPosition --;
                if(currentPosition < 0) v.check(false, "Shonic has attempted to go left from the leftmost lane in row ", i);
                flag = 1;
            }

            if(directions[i] == 'F')
            {
                flag = 1;
            }

               if(directions[i] == 'R')
            {
                currentPosition ++;
                if(currentPosition >= m) v.check(false, "Shonic has attempted to go right from the rightmost lane in row ", i);
                flag = 1;
            }

            if(flag == 0) v.check(false, "Output in row ", i, " does not match any of the directions listed in the problem description");

            if(spikefield[i + 1] [currentPosition] == '*') v.check(false, "Shonic has hit a spike in row ", i + 1, " lane ", currentPosition);
        }
    }

}
