fun main() {
  val input = System.`in`.bufferedReader()
  val chipmunks = input.readLine().toInt()
  val actions = (1..chipmunks).map {
    input.readLine()
  }
  val groups = input.readLine().toInt()
  repeat(groups) {
    val (start, finish) = input.readLine().split(" ").map { it.toInt() }
    val frequency = actions.asSequence().drop(start - 1).take(finish - start + 1).groupBy { it }.withDefault { emptyList() }
    val paper = frequency.getValue("Paper").size
    val rock = frequency.getValue("Rock").size
    val scissors = frequency.getValue("Scissors").size
    println(paper.coerceAtMost(rock.coerceAtMost(scissors)) * 3)
  }
}
