import java.io.*;
import java.util.*;

public class Maarten {
    public static void main(String[] args) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in))) {
            new Maarten().run(reader);
        }
    }

    public void run(BufferedReader reader) throws IOException {
        int n = Integer.parseInt(reader.readLine());

        char[] chipmunks = new char[n];
        for (int i = 0; i < n; i++) {
            chipmunks[i] = reader.readLine().charAt(0);
        }

        int[][] sums = new int[3][n + 1];
        for (int i = 0; i < 3; i++) {
            char c = "RPS".charAt(i);
            for (int j = 0; j < chipmunks.length; j++) {
                char d = chipmunks[j];
                sums[i][j + 1] = sums[i][j] + (c == d ? 1 : 0);
            }
        }

        int q = Integer.parseInt(reader.readLine());

        for (int i = 0; i < q; i++) {
            String[] line = reader.readLine().split(" ");
            int a = Integer.parseInt(line[0]);
            int b = Integer.parseInt(line[1]);
            System.out.println(3 * Arrays.stream(sums).mapToInt(s -> s[b] - s[a - 1]).min().getAsInt());
        }
    }
}
