import Node.Companion.DEAD_END
import kotlin.math.abs
import kotlin.math.max

/**
 * For a binary tree to be height-balanced, the absolute difference between the heights of the two children subtrees of any node is less than 2.
 * Sentence is confusing, replace by something like:
 * A binary tree is height-balanced when the absolute difference between the heights of the subtree is less than 2.
 */


fun main() {
  val input = System.`in`.bufferedReader()
  val nodes = input.readLine().toInt()
  val tree = mutableMapOf(0 to DEAD_END)
  input.lineSequence().take(nodes)
    .mapIndexed { index, line ->
      index + 1 to line.split(" ").map { it.toInt() }.let { (left, right) -> Node(index + 1, left, right) }
    }.toMap(tree)
  val root = tree[1]!!
  if (tree.isHeightBalancedRecursive(root)) return println("balanced")
  if (maxHeight > 2) return println("impossible")
  val leaves = tree.findLeavesRecursive(root, 0)
  leaves.sortedBy { it.second }.firstOrNull { (node) ->
    heightCacheRecursive.clear()
    tree[node.label] = DEAD_END
    val found = tree.isHeightBalancedRecursive(root)
    tree[node.label] = node
    found
  }?.let { println(it.first.label) } ?: println("impossible")
}

var maxHeight = 0

fun Map<Int, Node>.isHeightBalancedRecursive(node: Node): Boolean {
  if (node == DEAD_END || node.isLeaf()) {
    return true
  }
  val leftNode = get(node.left)!!
  val rightNode = get(node.right)!!
  if (isHeightBalancedRecursive(leftNode) && isHeightBalancedRecursive(rightNode)) {
    val left = calculateHeightRecursive(get(node.left)!!)
    val right = calculateHeightRecursive(get(node.right)!!)
    maxHeight = max(abs(left - right), maxHeight)
    return abs(left - right) < 2
  }
  return false
}

val heightCacheRecursive = mutableMapOf<Node, Int>()

fun Map<Int, Node>.calculateHeightRecursive(node: Node): Int =
  when {
    node in heightCacheRecursive -> heightCacheRecursive[node]!!
    node == DEAD_END -> 0
    node.isLeaf() -> 1
    else -> (1 + max(calculateHeightRecursive(get(node.left)!!), calculateHeightRecursive(get(node.right)!!))).also {
      heightCacheRecursive[node] = it
    }
  }

fun Map<Int, Node>.findLeavesRecursive(node: Node, depth: Int, force: Boolean = false): List<Pair<Node, Int>> {
  if (node.isLeaf()) return listOf(node to depth)
  val leaves = mutableListOf<Pair<Node, Int>>()
  val left = get(node.left)!!
  val right = get(node.right)!!
  leaves.takeUnless { !force && isHeightBalancedRecursive(left) }
    ?.addAll(findLeavesRecursive(get(node.left)!!, depth + 1, true))
  leaves.takeUnless { !force && isHeightBalancedRecursive(right) }
    ?.addAll(findLeavesRecursive(get(node.right)!!, depth + 1, true))
  return leaves
}

data class Node(
  val label: Int,
  val left: Int,
  val right: Int
) {
  companion object {
    val DEAD_END = Node(0, 0, 0)
  }

  fun isLeaf(): Boolean = left == 0 && right == 0
}


