import Node.Companion.DEAD_END
import kotlin.math.abs
import kotlin.math.max

fun main() {
  val input = System.`in`.bufferedReader()
  val nodes = input.readLine().toInt()
  val tree = mutableMapOf(0 to DEAD_END)
  input.lineSequence().take(nodes)
    .mapIndexed { index, line ->
      index + 1 to line.split(" ").map { it.toInt() }.let { (left, right) -> Node(index + 1, left, right) }
    }.toMap(tree)
  val root = tree[1]!!
  if (tree.isHeightBalancedRecursive(root)) return println("balanced")
  if (maxHeight > 2) return println("impossible")
  // corner case
  if (heightCacheRecursive[tree[root.left]!!]!! - heightCacheRecursive[tree[root.right]!!]!! > 2) return println("impossible")
  val unbalancedRoots = tree.findUnbalancedRoots(root)
  if (unbalancedRoots.size > 1) return println("impossible")
  val (rootOfAllEvil) = unbalancedRoots
  val left = tree[rootOfAllEvil.left]!!
  val right = tree[rootOfAllEvil.right]!!
  val leftHeight = heightCacheRecursive[tree[rootOfAllEvil.left]!!]!!
  val rightHeight = heightCacheRecursive[tree[rootOfAllEvil.right]!!]!!
  if (abs(leftHeight - rightHeight) > 2) return println("impossible")
  val targetRoot = when{
    leftHeight > rightHeight -> left
    rightHeight > leftHeight -> right
    tree.isHeightBalancedRecursive(left) -> right
    else -> left
  }

  val roots = tree.findLeavesRecursive(targetRoot, max(leftHeight, rightHeight))
  if(roots.size == 1){
    val (toDelete) = roots
    tree[toDelete.label] = DEAD_END
    heightCacheRecursive.clear()
    if (tree.isHeightBalancedRecursive(rootOfAllEvil))   return println(toDelete.label)
  }
  println("impossible")
}

var maxHeight = 0

fun Map<Int, Node>.isHeightBalancedRecursive(node: Node): Boolean {
  if (node == DEAD_END || node.isLeaf()) {
    return true
  } else if (node.label == 1) {
    calculateHeightRecursive(node)
  }
  val leftNode = get(node.left)!!
  val rightNode = get(node.right)!!
  val left = calculateHeightRecursive(leftNode)
  val right = calculateHeightRecursive(rightNode)
  if (isHeightBalancedRecursive(leftNode) && isHeightBalancedRecursive(rightNode)) {
    maxHeight = max(abs(left - right), maxHeight)
    return abs(left - right) < 2
  }
  return false
}

val heightCacheRecursive = mutableMapOf<Node, Int>()

fun Map<Int, Node>.calculateHeightRecursive(node: Node): Int =
  when {
    node in heightCacheRecursive -> heightCacheRecursive[node]!!
    node == DEAD_END -> 0
    node.isLeaf() -> 1
    else -> (1 + max(calculateHeightRecursive(get(node.left)!!), calculateHeightRecursive(get(node.right)!!)))
  }.also { heightCacheRecursive[node] = it }

fun Map<Int, Node>.findUnbalancedRoots(node: Node): List<Node> {
  if (node.isLeaf()) return emptyList()
  val nodes = mutableListOf<Node>()
  val left = get(node.left)!!
  val right = get(node.right)!!
  when (isHeightBalancedRecursive(left)) {
    false -> nodes.add(left)
    else -> nodes.addAll(findUnbalancedRoots(left))
  }
//  nodes.addAll(findUnbalancedRoots(left))
  when (isHeightBalancedRecursive(right)) {
    false -> nodes.add(right)
    else -> nodes.addAll(findUnbalancedRoots(right))
  }
//  nodes.addAll(findUnbalancedRoots(right))
  return nodes
}

fun Map<Int, Node>.findLeavesRecursive(node: Node, depth: Int, currentDepth: Int = 1): List<Node> {
  return when {
    node.isLeaf() && depth == currentDepth -> listOf(node)
    node.isLeaf() -> emptyList()
    else -> {
      val leaves = mutableListOf<Node>()
      val left = get(node.left)!!
      val right = get(node.right)!!
      leaves.takeUnless { left == DEAD_END }?.addAll(findLeavesRecursive(left, depth, currentDepth + 1))
      leaves.takeUnless { right == DEAD_END }?.addAll(findLeavesRecursive(right, depth, currentDepth + 1))
      leaves
    }
  }
}

data class Node(
  val label: Int,
  val left: Int,
  val right: Int
) {
  companion object {
    val DEAD_END = Node(0, 0, 0)
  }

  fun isLeaf(): Boolean = left == 0 && right == 0
}
