import java.io.*;

public class MaartenRecursive {

    int[][] tree;
    int chosen = 0;

    public static void main(String[] args) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in))) {
            new MaartenRecursive().run(reader);
        }
    }

    public void run(BufferedReader reader) throws IOException {
        int n = Integer.parseInt(reader.readLine());

        tree = new int[n + 1][2];
        for (int i = 1; i <= n; i++) {
            String[] firstLine = reader.readLine().split(" ");
            tree[i][0] = Integer.parseInt(firstLine[0]);
            tree[i][1] = Integer.parseInt(firstLine[1]);
        }

        check(1);
        System.out.println(chosen == 0 ? "balanced" : chosen);
    }

    Node check(int i) {
        if (i == 0) return new Node(0, 0);
        if (tree[i][0] == 0 && tree[i][1] == 0) return new Node(1, i);
        Node left = check(tree[i][0]);
        Node right = check(tree[i][1]);
        int diff = Math.abs(left.h - right.h);
        if (diff > 2) abort();
        if (diff == 2) {
            if (chosen > 0) abort();
            if (left.h > right.h) {
                if (left.l <= 0) abort();
                chosen = left.l;
                return new Node(left.h, -1);
            }
            if (left.h < right.h) {
                if (right.l <= 0) abort();
                chosen = right.l;
                return new Node(right.h, -1);
            }
        }
        // if (diff < 2):
        if (left.h > right.h) return new Node(1 + left.h, left.l);
        if (left.h < right.h) return new Node(1 + right.h, right.l);
        return new Node(1 + left.h, -1);
    }

    void abort() {
        System.out.println("impossible");
        System.exit(0);
    }

    static class Node {
        int h, l;

        public Node(int h, int l) {
            this.h = h;
            this.l = l;
        }
    }
}
