fun main() {
  val input = System.`in`.bufferedReader()
  input.readLine()
//  val lectureQueue = PriorityQueue<Lecture> { o1, o2 ->
//    when (o1.students) {
//      o2.students -> o1.rank.compareTo(o2.rank)
//      else -> o2.students.compareTo(o1.students)
//    }
//  }
//  val classesQueue = PriorityQueue<Class> { o1, o2 ->
//    when (o1.capacity) {
//      o2.capacity -> o2.rank.compareTo(o1.rank) // worst classroom first?
//      else -> o2.capacity.compareTo(o1.capacity)
//    }
//  }
  val lectureComperator: Comparator<Lecture> = Comparator { o1, o2 ->
    when (o1.students) {
      o2.students -> o1.rank.compareTo(o2.rank)
      else -> o2.students.compareTo(o1.students)
    }
  }
  val hallComperator: Comparator<Hall> = Comparator { o1, o2 ->
    when (o1.capacity) {
      o2.capacity -> o1.rank.compareTo(o2.rank)
      else -> o2.capacity.compareTo(o1.capacity)
    }
  }

  val lectureQueue =
    input.readLine().split(" ").mapIndexed { index, s -> Lecture(index + 1, s.toLong()) }.toSortedSet(lectureComperator)
  val hallQueue = input.readLine().split(" ").mapIndexed { index, s -> Hall(index + 1, s.toLong()) }.toSortedSet(hallComperator)
  val freeRooms = hallQueue.size - lectureQueue.size
  if(freeRooms < 0) return println("impossible")

  val assignment = mutableListOf<Pair<Int, Int>>()
  while (lectureQueue.isNotEmpty()) {
    if (hallQueue.isEmpty()) {
      return println("impossible")
    }
    val lecture = lectureQueue.sortedWith(lectureComperator).first()
    val hall = hallQueue.sortedWith(hallComperator).first()
//    if (hall.capacity < lecture.students) {
//      return println("impossible")
//    } else if (hall.capacity == lecture.students) {
//      lectureQueue.remove(lecture)
//      hallQueue.remove(hall)
//      assignment.add(lecture.rank to hall.rank)
//      continue
//    }

    val availableHals = hallQueue.filter { it.capacity>= lecture.students }
    val possibleLecturers = lectureQueue.take(availableHals.size + freeRooms)
    val bestLecture = possibleLecturers.minByOrNull { it.rank } ?: return println("impossible")
    val bestHall = availableHals.minByOrNull { it.rank } ?: return println("impossible")
    lectureQueue.remove(bestLecture)
    hallQueue.remove(bestHall)
    assignment.add(bestLecture.rank to bestHall.rank)
  }
  println(assignment.sortedBy { it.first }.map { it.second }.joinToString(separator = " "))
}

data class Lecture(val rank: Int, val students: Long)
data class Hall(val rank: Int, val capacity: Long)
