#include <bits/stdc++.h>
using namespace std;

#define ll long long
const int NMAX = 100000;

vector<int>g[NMAX+5];
vector<int>gt[NMAX+5];
bitset<NMAX+5>viz;
stack<int> st;
vector< vector<int> >strong_components;

///Implementation with Kosaraju

void dfs(int node){
    viz[node] =1 ;
    for(auto x : g[node]){
        if(!viz[x])
            dfs(x);
    }

}

void dfs_kosaraju(int node){
    viz[node] =1;

    for(int i =0; i < g[node].size(); i++) {
        if(!viz[g[node][i]])
            dfs_kosaraju(g[node][i]);
    }

    st.push(node);
}

void dfs_kosaraju_component(int node, vector<int> strong_component){
    viz[node] =1;
    strong_component.push_back(node);

    for(int i =0; i < g[node].size(); i++) {
        if(!viz[g[node][i]])
            dfs(g[node][i]);
    }
}

void kosaraju(int n){
    for(int i =1;i<=n;i++){
        if(!viz[i])
            dfs_kosaraju(i);
    }

    viz.reset();

    while(!st.empty()){
        int node = st.top();
        st.pop();

        if(!viz[node]){
            vector<int> strong_component;
            dfs_kosaraju_component(node, strong_component);
            strong_components.push_back(strong_component);
        }
    }

}



int main(){
    int n, m, x, y;
    cin>>n>>m;
    for(int i =1; i <=m; i++){
        cin>>x>>y;
        g[x].push_back(y);
        gt[y].push_back(x);
    }
    kosaraju(n);
    viz.reset();

    int components = 0;
    for(int i =1; i<=n;i++){
        if(viz[i] == 0)
        {
            components++;
            dfs(i);
        }
    }

    cout<<(strong_components.size()-1) + (components -1)<<"\n";

    return 0;
}


