import sys
sys.setrecursionlimit(100_000)

n, m = map(int, input().split())
edges, rev = ([[] for _ in range(n)] for _ in range(2))
for _ in range(m):
    a, b = (int(x) - 1 for x in input().split())
    edges[a].append(b)
    rev[b].append(a)

index, lower, on_stack = [-1] * n, [-1] * n, [False] * n
counter, stack, SCC = 0, [], []


def strong_connected(v):
    global counter, stack, SCC
    counter += 1
    index[v], lower[v] = counter, counter
    stack.append(v)
    on_stack[v] = True

    for w in edges[v]:
        if index[w] < 0:
            strong_connected(w)
            lower[v] = min(lower[v], lower[w])
        elif on_stack[w]:
            lower[v] = min(lower[v], index[w])

    ssc = set()
    if lower[v] == index[v]:
        while True:
            w = stack.pop()
            on_stack[w] = False
            ssc.add(w)
            if w == v: break
        SCC.append(ssc)


for v in range(n):
    if index[v] < 0:
        strong_connected(v)

if len(SCC) == 1: print(0), exit()
num_without_outgoing = sum(all(all(e in scc for e in edges[v]) for v in scc) for scc in SCC)
num_without_incoming = sum(all(all(e in scc for e in rev[v]) for v in scc) for scc in SCC)
print(max(num_without_incoming, num_without_outgoing))
