import kotlin.math.max

fun main() {
  val input = System.`in`.bufferedReader()
  val (sectors, highways) = input.readLine().split(" ").map { it.toLong() }
  if (sectors == 1L) return println(0)
  val graph = input.lineSequence()
    .map { line ->
      val (from, destination) = line.split(" ").map { it.toLong() }
      from to destination
    }.groupBy({ it.first }) { it.second }.withDefault { emptyList() }
  val transposed = mutableMapOf<Long, List<Long>>().withDefault { emptyList() }
  val seen = mutableSetOf<Long>()
  val l = mutableMapOf<Long, Long>()
  var index = sectors

  // Kosarju SCC: Pass 1
  fun visit(node: Long) {
    if (seen.add(node)) {
      graph.getValue(node).forEach {
        visit(it)
        transposed[it] = transposed.getValue(it) + node
      }
      l[--index] = node
    }
  }
  (1..sectors).forEach { visit(it) }

  // Kosarju SCC: pass 2
  val components = mutableMapOf<Long, Long>()
  fun assign(node: Long, root: Long) {
    if (node in seen) {
      seen.remove(node)
      components[node] = root
      transposed.getValue(node).forEach { assign(it, root) }
    }
  }
  l.values.forEach { assign(it, it) }

  val stronglyConnected = components.entries
    .groupBy { it.value }.values
    .map { ivl -> ivl.map { it.key } }

  val bridgesOutRequired = stronglyConnected.sumOf { cluster -> cluster.count { graph.getValue(it).isEmpty() } }
  val bridgesInRequired = stronglyConnected.sumOf { cluster -> cluster.count { transposed.getValue(it).isEmpty() } }

  println(max(max(bridgesInRequired, bridgesOutRequired), stronglyConnected.size.takeIf { it > 1 } ?: 0))
}
