#include <bits/stdc++.h>
using namespace std;

#define ll long long
const int NMAX = 100000;

vector<int>g[NMAX+5];
int low_link[NMAX+5], ids[NMAX+5];
bitset<NMAX+5>in_stack, viz;
stack<int> st;
vector< vector<int> >strong_components;
int indx;



///Implementation with Tarjan

void dfs_tarjan(int node){
    st.push(node);
    in_stack[node] = 1;
    ids[node] = indx;
    low_link[node] = indx;
    indx++;

    for(int i =0; i < g[node].size(); i++){
        int x = g[node][i];
        if(ids[x] == 0)
            dfs_tarjan(x);
        if(in_stack[x])
            low_link[node] = min(low_link[node], low_link[x]);

    }


    if(ids[node] == low_link[node]){
        vector<int> strong_component;
        int x = -1;
        do{
            x = st.top();
            in_stack[x] = 0;
            low_link[x] = ids[node];
            strong_component.push_back(x);
            st.pop();

        }
        while(x != node);
        strong_components.push_back(strong_component);
    }
}

void tarjan(int n){
    indx = 1;
    for(int i =1; i <=n; i++)
    {
        if(ids[i] == 0){
            dfs_tarjan(i);
        }
    }
}


int main(){
    int n, m, x, y;
    cin>>n>>m;
    for(int i =1; i <=m; i++){
        cin>>x>>y;
        g[x].push_back(y);
    }
    tarjan(n);
    if(strong_components.size() == 1){
        cout<<0<<"\n";
        return 0;
    }

    vector<int>node_components(n+1, 0);
    for(int i =0; i < strong_components.size(); i++)
    {
        for(auto x : strong_components[i])
            node_components[x] = i;
    }


    vector<int>out_edges(strong_components.size(), 0);
    vector<int>in_edges(strong_components.size(), 0);
    for(int i =1; i <= n; i++){
        for(auto x : g[i]){
            if(node_components[x] != node_components[i]){
                in_edges[node_components[x]]++;
                out_edges[node_components[i]]++;
            }
        }
    }

    int leaves =0;
    int root = 0;
    for(int i =0; i < out_edges.size(); i++)
    {
        if(out_edges[i] == 0)
            leaves++;
        if(in_edges[i] == 0)
            root++;
    }
    cout<<max(root, leaves)<<"\n";



    return 0;
}


