import java.io.*;
import java.util.*;

public class MaartenTarjan {
    public static void main(String[] args) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in))) {
            new MaartenTarjan().run(reader);
        }
    }

    public void run(BufferedReader reader) throws IOException {
        String[] firstLine = reader.readLine().split(" ");
        int n = Integer.parseInt(firstLine[0]);
        int m = Integer.parseInt(firstLine[1]);

        Vertex[] vertices = new Vertex[n];
        for (int i = 0; i < n; i++) {
            vertices[i] = new Vertex(i);
        }
        for (int i = 0; i < m; i++) {
            String[] line = reader.readLine().split(" ");
            int a = Integer.parseInt(line[0]) - 1;
            int b = Integer.parseInt(line[1]) - 1;
            vertices[a].edges.add(vertices[b]);
            vertices[b].rev.add(vertices[a]);
        }

        tarjan(vertices);

        if (SCC.size() == 1) {
            System.out.println(0);
            return;
        }

        int numWithoutOutgoing = 0, numWithoutIncoming = 0;
        for (Set<Vertex> scc : SCC) {
            if (scc.stream().allMatch(v -> v.edges.stream().allMatch(e -> scc.contains(vertices[e.i]))))
                numWithoutOutgoing++;
            if (scc.stream().allMatch(v -> v.rev.stream().allMatch(e -> scc.contains(vertices[e.i]))))
                numWithoutIncoming++;
        }
        System.out.println(Math.max(numWithoutIncoming, numWithoutOutgoing));
    }

    public static class Vertex {
        List<Vertex> edges = new ArrayList<>(), rev = new ArrayList<>();
        int i, lower = -1, index = -1;
        boolean onstack = false;

        public Vertex(int i) {
            this.i = i;
        }
    }

    int counter = 0;
    Stack<Vertex> stack;
    List<Set<Vertex>> SCC;

    public List<Set<Vertex>> tarjan(Vertex[] vertices) {
        stack = new Stack<>();
        SCC = new ArrayList<>();
        for (Vertex v : vertices) {
            if (v.index < 0) // not yet visited
                strongConnected(v);
        }
        return SCC;
    }

    public void strongConnected(Vertex v) {
        v.lower = v.index = counter++;
        stack.push(v);
        v.onstack = true;

        for (Vertex w : v.edges) {
            if (w.index < 0) {
                strongConnected(w);
                v.lower = Math.min(v.lower, w.lower);
            } else if (w.onstack) {
                v.lower = Math.min(v.lower, w.index);
            }
        }

        Set<Vertex> ssc = new HashSet<>();
        if (v.lower == v.index) {
            while (true) {
                Vertex w = stack.pop();
                w.onstack = false;
                ssc.add(w);
                if (w == v) break;
            }
            SCC.add(ssc);
        }
    }
}
