import java.io.*;
import java.util.*;

public class MaartenOverflow {
    public static void main(String[] args) {
        try (Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)))) {
            new MaartenOverflow().run(sc);
        }
    }

    public void run(Scanner sc) {
        int n = sc.nextInt();
        Stack<Integer> heights = new Stack<>();
        Stack<Integer> widths = new Stack<>();
        heights.push(-1);
        widths.push(0);
        int maxArea = 0;
        for (int i = 0; i <= n; i++) {
            final int h, w;
            if (i < n) {
                h = sc.nextInt();
                w = sc.nextInt();
            } else h = w = 0;
            int addW = 0;
            while (h <= heights.peek()) {
                int oldH = heights.pop();
                int oldW = widths.pop();
                addW += oldW;
                maxArea = Integer.max(maxArea, oldH * addW);
            }
            heights.push(h);
            widths.push(w + addW);
        }
        System.out.println(maxArea);
    }
}
