from math import log2

n, t = [int(x) for x in input().split()]

if t == 0 or n == 0:
    print("0 0")
    exit()

if n == 1:
    print(f"{t} 1")
    exit()

total_time = int(log2(n - 1)) + 2


def num_exams_that_can_be_graded(num_TAs):
    """
    T = Train TA
    G = Grade
    Example: with 6 TAs and 5 total_time, we can grade 15 exams:
        1         T
        2     T       T
        3   T   T   T   G
        4  G G G G G G  G
        5  G G G G G G  G
    complete_levels = 2 (= ⌊log₂(6 + 1)⌋)
    overflow_level  = 6 (= 2 * (6 - (2 ^ 2 - 1)))
    previous_level  = 1 (= 2 ^ 2 - 6 / 2)
    return 1 * (5 - 2) + 6 * (5 - 2 - 1)
    """
    complete_levels = int(log2(num_TAs + 1))
    overflow_level = 2 * (num_TAs - (2 ** complete_levels - 1))
    previous_level = 2 ** complete_levels - overflow_level // 2
    return previous_level * (total_time - complete_levels) + overflow_level * (total_time - complete_levels - 1)


low = 0
high = n - 1
while low < high:
    mid = (low + high) // 2
    if num_exams_that_can_be_graded(mid) >= n:
        high = mid
    else:
        low = mid + 1

print(f"{total_time * t} {high + 1}")
